function [dsdt]=Problema2C(t,s,N)
% ------------------------------------------------------------
% funcin PROBLEMA2C: Ecuaciones del problema de dos cuerpos
% con el segundo cuerpo en rbita en torno al primero, que se
% considera en reposo.
%
% PARMETROS DE ENTRADA:
% N: masa del cuerpo central M1 en unidades de la masa solar.
% t: tiempo. No se usa en el cuerpo de la funcin, pero es necesario
% incluirlo entre los parmetros de entrada porque lo requieren las
% funciones ODE de Matlab. Sus unidades son aos.
% s: un vector de cuatro componentes. Las dos primeras componentes son
% las componentes del vector de posicin del cuerpo M2 (en unidades
% astronmicas). La tercera y la cuerta componente son las componentes
% de la velocidad del cuerpo M2 (en km/s).
%
% PARMETROS DE SALIDA:
% dsdt: un vector que contiene las derivadas con respecto al tiempo
% de las componentes del vector s.
x=s(1);
y=s(2);
vx=s(3);
vy=s(4);
dsdt(1)=0.2109*vx;
dsdt(2)=0.2109*vy;
dsdt(3)=-187.1*N*x/(x^2+y^2)^(3/2);
dsdt(4)=-187.1*N*y/(x^2+y^2)^(3/2);
% Hay que transponer dsdt porque las funciones ode trabajan con vectores
% columna
dsdt=dsdt';
end
